#!/bin/sh

echo "SEWOO TECH"
echo "SEWOO TECH CPCL CUPS DRIVER Mac OS Installer"
echo "---------------------------------------"
echo ""
echo "Models included:"

echo "                           LK-P11"
echo "                           LK-P12"
echo "                           LK-P30"
echo "                           LK-P41"
echo "                           LK-P43"
echo "                           LK-P4XX"
echo "                           LK-P3XX"
echo ""

ROOT_UID=0

if [ "$UID" -ne "$ROOT_UID" ]
then
    echo "This script requires root user access..."
    echo "Re-run as root user..."
    exit 1
fi

if [ ! -z $DESTDIR ]
then
    echo "DESTDIR set to $DESTDIR"
    echo ""
fi

SERVERROOT=$(grep '^ServerRoot' /etc/cups/cupsd.conf | awk '{print $2}')

if [ -z $FILTERDIR ] || [ -z $PPDDIR ]
then
    echo "Searching for ServerRoot, ServerBin, and DataDir tags in /etc/cups/cupsd.conf"
    echo ""

    if [ -z $FILTERDIR ]
    then
        SERVERBIN=$(grep '^ServerBin' /etc/cups/cupsd.conf | awk '{print $2}')

        if [ -z $SERVERBIN ]
        then
            echo "ServerBin tag not present in cupsd.conf - using default"
            FILTERDIR=usr/libexec/cups/filter
        elif [ ${SERVERBIN:0:1} = "/" ]
        then
            echo "ServerBin tag is present as an absolute path"
            FILTERDIR=$SERVERBIN/filter
        else
            echo "ServerBin tag is present as a relative path - appending to ServerRoot"
            FILTERDIR=$SERVERROOT/$SERVERBIN/filter
        fi
    fi

    echo ""

    if [ -z $PPDDIR ]
    then
        DATADIR=$(grep '^DataDir' /etc/cups/cupsd.conf | awk '{print $2}')

        if [ -z $DATADIR ]
        then
            echo "DataDir tag not present in cupsd.conf - using default"
            PPDDIR=/usr/share/cups/model/SEWOO
        elif [ ${DATADIR:0:1} = "/" ]
        then
            echo "DataDir tag is present as an absolute path"
            PPDDIR=$DATADIR/model/SEWOO
        else
            echo "DataDir tag is present as a relative path - appending to ServerRoot"
            PPDDIR=$SERVERROOT/$DATADIR/model/SEWOO
        fi
    fi

    echo ""

    echo "ServerRoot = $SERVERROOT"
    echo "ServerBin  = $SERVERBIN"
    echo "DataDir    = $DATADIR"
    echo ""
fi

echo "Copying PPDs filer /Library/Printers/PPDs/Contents/Resource/SEWOO"
mkdir -p /Library/Printers/PPDs/Contents/Resource/SEWOO
cp *.gz /Library/Printers/PPDs/Contents/Resource/SEWOO

mkdir -p $DESTDIR/$FILTERDIR

echo "Copying rasterlkp11 filter to $DESTDIR/$FILTERDIR"
chmod 755 rasterlkp11
cp rasterlkp11 $DESTDIR/$FILTERDIR
echo ""

echo "Copying rasterlkp12 filter to $DESTDIR/$FILTERDIR"
chmod 755 rasterlkp12
cp rasterlkp12 $DESTDIR/$FILTERDIR
echo ""

echo "Copying rasterlkp30 filter to $DESTDIR/$FILTERDIR"
chmod 755 rasterlkp30
cp rasterlkp30 $DESTDIR/$FILTERDIR
echo ""

echo "Copying rasterlkp41 filter to $DESTDIR/$FILTERDIR"
chmod 755 rasterlkp41
cp rasterlkp41 $DESTDIR/$FILTERDIR
echo ""

echo "Copying rasterlkp43 filter to $DESTDIR/$FILTERDIR"
chmod 755 rasterlkp43
cp rasterlkp43 $DESTDIR/$FILTERDIR
echo ""

echo "Copying rasterlkp4xx filter to $DESTDIR/$FILTERDIR"
chmod 755 rasterlkp4xx
cp rasterlkp4xx $DESTDIR/$FILTERDIR
echo ""

echo "Copying rasterlkp3xx filter to $DESTDIR/$FILTERDIR"
chmod 755 rasterlkp3xx
cp rasterlkp3xx $DESTDIR/$FILTERDIR
echo ""

echo "Copying model ppd files to /Library/Printers/PPDs/Contents/Resources/SEWOO"
mkdir -p /Library/Printers/PPDs/Contents/Resources/SEWOO
cp *.gz /Library/Printers/PPDs/Contents/Resources/SEWOO
echo ""


if [ -e /System/Library/LaunchDaemons/printer.plist ]
then
	echo "Restarting CUPS"
	sudo killall cupsd
	sudo cupsd
	sudo launchctl  unload -w /System/Library/LaunchDaemons/printer.plist
	sudo launchctl load -w /System/Library/LaunchDaemons/printer.plist
	echo ""
fi

if [ -e /System/Library/LaunchDaemons/org.cups.cupsd.plist ]
then
	echo "Restarting CUPS"
	sudo launchctl  unload /System/Library/LaunchDaemons/org.cups.cupsd.plist
	sudo launchctl load /System/Library/LaunchDaemons/org.cups.cupsd.plist
	echo ""
fi


echo "Install Complete"
echo "Add printer queue using Printing Manager, or"
echo "Add printer queue using OS tool, http://localhost:631, or http://127.0.0.1:631"
echo ""
